----------------
title : C++ 레퍼런스 - string 의 find 함수
cat_title : find
ref_title : find, basic_string::find
path : /C++ Reference/string
publish_date : 2020-07-17
----------------

##@ cpp-ref-start

#@ find

```cpp-formatted
size_type find(const basic_string& str, size_type pos = 0) const;      // (1)
size_type find(const CharT* s, size_type pos, size_type count) const;  // (2)
size_type find(const CharT* s, size_type pos = 0) const;               // (3)
size_type find(CharT ch, size_type pos = 0) const;                     // (4)
template <class T>
size_type find(const T& t, size_type pos = 0) const;  // (5)
```

문자열에서 원하는 문자열의 위치를 찾는다.

탐색은 `pos` 부터 시작한다.

1. 문자열에서 `str` 의 위치를 리턴한다.
2. `s` 가 가리키는 문자 부터 `count` 개 만큼을 취한 부분 문자열을 원 문자열에서 찾는다. 참고로 s 에 중간에 `NULL` 이 있어도 괜찮다.
3. `s` 가 가리키는 문자열을 원 문자열에서 검색한다. 이 때 `s` 는 널 종료 문자열로 간주된다.
4. 원 문자열에서 문자 `ch` 의 위치를 찾는다.
5. `t` 를 `string_view` 객체인 `sv` 로 변환한 뒤에(`std::basic_string_view<CharT, Traits> sv = t;`), `sv` 를 원 문자열에서 찾는다. 이 때 `T` 는 `string_view` 로 변환 가능한 타입이어야 한다.

만약에 문자열을 찾는데 성공하였다면, 해당 문자열의 **시작 위치** 를 반환하고, 찾지 못한다면 `npos` 를 리턴한다. `npos` 는 `string::npos` 로 정의되는 상수 이다.

### 인자들

* `str`	-	찾고자 하는 문자열
* `pos`	-	검색을 시작할 위치
* `count`	-	찾고자 하는 문자열의 길이
* `s`	-	찾고자 하는 문자열을 가리키는 포인터
* `ch`	-	찾고자 하는 문자
* `t`	-	찾고자 하는 `string_view` 로 변환 가능한 객체

### 리턴값

문자열을 찾았다면, 해당 문자열의 시작 위치를 리턴하고, 그렇지 않을 경우 `npos` 를 리턴한다.

```cpp-formatted
#include <iostream>
#include <string>

void print(std::string::size_type n, std::string const &s) {
  if (n == std::string::npos) {
    std::cout << "not found\n";
  } else {
    std::cout << "found: " << s.substr(n) << '\n';
  }
}

int main() {
  std::string::size_type n;
  std::string const s = "This is a string";

  // s 의 처음 부터 찾는다.
  n = s.find("is");
  print(n, s);

  // s 의 5번째 문자부터 찾는다.
  n = s.find("is", 5);
  print(n, s);

  // 단일 문자 (a) 를 찾는다.
  n = s.find('a');
  print(n, s);

  // 단일 문자 (q) 를 찾는다.
  n = s.find('q');
  print(n, s);
}
```

실행 결과

```exec
found: is is a string
found: is a string
found: a string
not found
```

### 참고 자료

* `strstr` : 문자열에서 원하는 부분 문자열을 리턴한다.
* `strchr` : 문자열에서 특정 문자의 위치를 찾는다.
* `rfind` : 문자열에서 특정 문자열이 마지막으로 나타나는 위치를 찾는다.
* `find_first_of` : 주어진 문자들 중 가장 먼저 나타나는 문자의 위치를 찾는다.
* `find_first_not_of` : 주어진 문자가 아닌 문자가 가장 먼저 나타나는 문자의 위치를 찾는다.
* `find_last_of` : 주어진 문자들 중 가장 끝에 나타나는 문자의 위치를 찾는다.
* `find_last_not_of` : 뒤에서 부터 주어진 문자에 포함되지 않는 문자의 위치를 찾는다.
* `search` : 특정 범위의 원소를 찾는다.